const sqlite3 = require('sqlite3').verbose();
const db = new sqlite3.Database('./database.db');

// Create tables with sample data
db.serialize(() => {
  // Create tables (same as in index.js)
  db.run(`
    CREATE TABLE IF NOT EXISTS users (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT NOT NULL,
      email TEXT UNIQUE NOT NULL,
      password TEXT NOT NULL,
      phone TEXT
    )
  `);

  db.run(`
    CREATE TABLE IF NOT EXISTS bookings (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      user_id INTEGER NOT NULL,
      transport_type TEXT NOT NULL,
      departure TEXT NOT NULL,
      destination TEXT NOT NULL,
      departure_time TEXT NOT NULL,
      arrival_time TEXT NOT NULL,
      seat_number TEXT NOT NULL,
      price REAL NOT NULL,
      status TEXT DEFAULT 'confirmed',
      FOREIGN KEY(user_id) REFERENCES users(id)
    )
  `);

  db.run(`
    CREATE TABLE IF NOT EXISTS transports (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      type TEXT NOT NULL,
      departure TEXT NOT NULL,
      destination TEXT NOT NULL,
      departure_time TEXT NOT NULL,
      arrival_time TEXT NOT NULL,
      available_seats INTEGER NOT NULL,
      price REAL NOT NULL
    )
  `);

  // Insert sample transport data
  const transports = [
    {
      type: 'bus',
      departure: 'New York',
      destination: 'Boston',
      departure_time: '2023-12-15 08:00:00',
      arrival_time: '2023-12-15 12:00:00',
      available_seats: 30,
      price: 45.99
    },
    {
      type: 'train',
      departure: 'Chicago',
      destination: 'Denver',
      departure_time: '2023-12-16 09:30:00',
      arrival_time: '2023-12-16 18:45:00',
      available_seats: 50,
      price: 89.50
    }
  ];

  transports.forEach(transport => {
    db.run(
      `INSERT INTO transports (type, departure, destination, departure_time, arrival_time, available_seats, price) 
       VALUES (?, ?, ?, ?, ?, ?, ?)`,
      [
        transport.type,
        transport.departure,
        transport.destination,
        transport.departure_time,
        transport.arrival_time,
        transport.available_seats,
        transport.price
      ]
    );
  });

  console.log('Database initialized with sample data');
});

db.close();
