import React, { useState } from 'react'

const App: React.FC = () => {
  const [stockInput, setStockInput] = useState('')
  const [reportFormat, setReportFormat] = useState('basic')

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    // TODO: Implement report generation
    console.log(`Generating ${reportFormat} report for: ${stockInput}`)
  }

  return (
    <div className="app">
      <h1>Stock Report Generator</h1>
      <form onSubmit={handleSubmit}>
        <div className="input-group">
          <label htmlFor="stock-input">Stock Symbol/Name:</label>
          <input
            id="stock-input"
            type="text"
            value={stockInput}
            onChange={(e) => setStockInput(e.target.value)}
            placeholder="e.g. AAPL, TSLA"
          />
        </div>
        
        <div className="input-group">
          <label>Report Format:</label>
          <select 
            value={reportFormat}
            onChange={(e) => setReportFormat(e.target.value)}
          >
            <option value="basic">Basic Report</option>
            <option value="detailed">Detailed Report</option>
            <option value="financial">Financial Analysis</option>
          </select>
        </div>

        <button type="submit">Generate Report</button>
      </form>
    </div>
  )
}

export default App