import React from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Navbar from './components/Navbar'
import BookingForm from './components/BookingForm'
import './styles/main.css'

const App: React.FC = () => {
  return (
    <Router>
      <div className="app-container">
        <Navbar />
        <main className="main-content">
          <Routes>
            <Route path="/" element={<Home />} />
            <Route path="/bookings" element={<Bookings />} />
            <Route path="/reimbursements" element={<Reimbursements />} />
          </Routes>
        </main>
      </div>
    </Router>
  )
}

const Home = () => <div>Welcome to Travel Reimbursement System</div>
import BookingForm from './components/BookingForm'

const Bookings = () => (
  <div className="bookings-page">
    <h1>Travel Bookings</h1>
    <BookingForm />
  </div>
)
const Reimbursements = () => <div>Reimbursement Portal</div>

export default App