import { useState } from 'react'
import './styles/main.scss'

function App() {
  const [currentPage, setCurrentPage] = useState('home')

  return (
    <div className="app">
      <header className="header">
        <h1>Solar Energy Solutions</h1>
        <nav>
          <button onClick={() => setCurrentPage('home')}>Home</button>
          <button onClick={() => setCurrentPage('products')}>Products</button>
          <button onClick={() => setCurrentPage('news')}>News</button>
          <button onClick={() => setCurrentPage('contact')}>Contact</button>
        </nav>
      </header>

      <main className="main-content">
        {currentPage === 'home' && <HomePage />}
        {currentPage === 'products' && <ProductsPage />}
        {currentPage === 'news' && <NewsPage />}
        {currentPage === 'contact' && <ContactPage />}
      </main>

      <footer className="footer">
        © {new Date().getFullYear()} Solar Energy Solutions
      </footer>
    </div>
  )
}

function HomePage() {
  return (
    <section>
      <h2>About Our Company</h2>
      <p>Leading provider of solar energy solutions since 2010...</p>
    </section>
  )
}

function ProductsPage() {
  return <section>{/* Product listings will go here */}</section>
}

function NewsPage() {
  return <section>{/* News articles will go here */}</section>
}

function ContactPage() {
  return <section>{/* Contact form will go here */}</section>
}

export default App