// Testimonial data
const testimonials = [
  {
    name: "John D.",
    quote: "Fundraiser Day helped us raise over $50,000 for our cause!"
  },
  {
    name: "Sarah M.",
    quote: "An amazing event that brought our community together."
  },
  {
    name: "Robert T.",
    quote: "The best fundraising experience we've ever had."
  }
];

// Offer data
const offers = [
  {
    title: "Matching Donations",
    description: "All donations matched 2:1 today!"
  },
  {
    title: "VIP Experience",
    description: "Donate $100+ for exclusive perks"
  },
  {
    title: "Early Bird Special",
    description: "First 50 donors get bonus gifts"
  }
];

// Initialize carousels
function initCarousels() {
  // Testimonial carousel
  const testimonialCarousel = document.querySelector('.testimonial-carousel');
  
  testimonials.forEach(testimonial => {
    const testimonialElement = document.createElement('div');
    testimonialElement.className = 'testimonial';
    testimonialElement.innerHTML = `
      <blockquote>"${testimonial.quote}"</blockquote>
      <cite>- ${testimonial.name}</cite>
    `;
    testimonialCarousel?.appendChild(testimonialElement);
  });

  // Offer carousel
  const offerCarousel = document.querySelector('.offer-carousel');
  
  offers.forEach(offer => {
    const offerElement = document.createElement('div');
    offerElement.className = 'offer';
    offerElement.innerHTML = `
      <h3>${offer.title}</h3>
      <p>${offer.description}</p>
    `;
    offerCarousel?.appendChild(offerElement);
  });

  // Add basic auto-rotation functionality
  setInterval(() => {
    if (testimonialCarousel) {
      testimonialCarousel.scrollLeft += 300;
      if (testimonialCarousel.scrollLeft >= testimonialCarousel.scrollWidth - 300) {
        testimonialCarousel.scrollLeft = 0;
      }
    }
    
    if (offerCarousel) {
      offerCarousel.scrollLeft += 300;
      if (offerCarousel.scrollLeft >= offerCarousel.scrollWidth - 300) {
        offerCarousel.scrollLeft = 0;
      }
    }
  }, 3000);
}

// Initialize app when DOM is loaded
document.addEventListener('DOMContentLoaded', initCarousels);