import React from 'react'
import ReactDOM from 'react-dom/client'

const App: React.FC = () => {
  return (
    <div className="app">
      <header>
        <h1>CleanHome Professional Cleaning Services</h1>
      </header>
      <nav>
        <a href="#services">Our Services</a>
        <a href="#booking">Book a Service</a>
        <a href="#contact">Contact Us</a>
      </nav>
      <main className="container">
        <section id="services" className="card">
          <h2>Our Cleaning Services</h2>
          <p>We offer comprehensive cleaning solutions for your home.</p>
        </section>
        <section id="booking" className="card">
          <h2>Book a Service</h2>
          <p>Schedule your cleaning appointment today.</p>
        </section>
        <section id="contact" className="card">
          <h2>Contact Us</h2>
          <p>Have questions? Reach out to our customer service.</p>
        </section>
      </main>
    </div>
  )
}

ReactDOM.createRoot(document.getElementById('root')!).render(
  <React.StrictMode>
    <App />
  </React.StrictMode>
)