import './styles.css';

const app = document.getElementById('app')!;

// Render navbar
app.innerHTML = `
  <nav class="navbar">
    <h1>Phone Operator Services</h1>
  </nav>
  <div class="main-container">
    <section id="plans">
      <h2>Service Plans</h2>
      <div class="service-plans" id="service-plans"></div>
    </section>
    <section id="support">
      <h2>Customer Support</h2>
      <div class="support-form">
        <textarea placeholder="Describe your issue"></textarea>
        <button id="submit-request">Submit Request</button>
      </div>
    </section>
  </div>
`;

// Sample service plans data
const plans = [
  { name: 'Basic', price: '$10/month', features: ['100 minutes', 'Unlimited texts', '1GB data'] },
  { name: 'Standard', price: '$20/month', features: ['300 minutes', 'Unlimited texts', '5GB data'] },
  { name: 'Premium', price: '$30/month', features: ['Unlimited minutes', 'Unlimited texts', '15GB data'] }
];

// Render service plans
const plansContainer = document.getElementById('service-plans')!;
plans.forEach(plan => {
  const featuresHTML = plan.features.map(f => `<li>${f}</li>`).join('');
  plansContainer.innerHTML += `
    <div class="service-plan">
      <h3>${plan.name} - ${plan.price}</h3>
      <ul>${featuresHTML}</ul>
    </div>
  `;
});

// Add support form handler
document.getElementById('submit-request')?.addEventListener('click', () => {
  alert('Support request submitted! We will contact you shortly.');
});