import { useState } from 'react'
import './App.css'

function App() {
  const [companies] = useState([
    { id: 1, name: 'Company A', revenue: 1000000, profit: 250000 },
    { id: 2, name: 'Company B', revenue: 1500000, profit: 300000 },
    { id: 3, name: 'Company C', revenue: 800000, profit: 200000 }
  ])

  return (
    <div className="app" style={{ backgroundColor: 'mintcream' }}>
      <h1 style={{ color: 'teal' }}>Financial Dashboard</h1>
      <div className="dashboard">
        <div className="company-list" style={{ borderColor: 'teal' }}>
          <h2 style={{ color: 'teal' }}>Companies</h2>
          {companies.map(company => (
            <div key={company.id} className="company-card" style={{ borderColor: 'teal' }}>
              <h3>{company.name}</h3>
              <p>Revenue: ${company.revenue.toLocaleString()}</p>
              <p>Profit: ${company.profit.toLocaleString()}</p>
            </div>
          ))}
        </div>
        <div className="reports" style={{ borderColor: 'teal' }}>
          <h2 style={{ color: 'teal' }}>Consolidated Reports</h2>
          {/* Reports will be added here */}
        </div>
      </div>
    </div>
  )
}

export default App