import { createRouter, createWebHistory } from 'vue-router'
import LeadsView from '../views/LeadsView.vue'
import ReportsView from '../views/ReportsView.vue'
import SettingsView from '../views/SettingsView.vue'

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/leads',
      name: 'leads',
      component: LeadsView
    },
    {
      path: '/reports',
      name: 'reports',
      component: ReportsView
    },
    {
      path: '/settings',
      name: 'settings',
      component: SettingsView
    },
    {
      path: '/',
      redirect: '/leads'
    }
  ]
})

export default router