import React, { useState } from 'react';
import '../styles/global.css';
const App = () => {
    const [messages, setMessages] = useState([]);
    const [input, setInput] = useState('');
    const handleSend = () => {
        if (input.trim()) {
            setMessages([...messages, { text: input, sender: 'user' }]);
            // TODO: Add bot response logic
            setInput('');
        }
    };
    return (React.createElement("div", { className: "app-container" },
        React.createElement("div", { className: "chat-container" },
            React.createElement("div", { className: "messages" }, messages.map((msg, i) => (React.createElement("div", { key: i, className: `message ${msg.sender}` }, msg.text)))),
            React.createElement("div", { className: "input-area" },
                React.createElement("input", { type: "text", value: input, onChange: (e) => setInput(e.target.value), onKeyPress: (e) => e.key === 'Enter' && handleSend(), placeholder: "Type your message..." }),
                React.createElement("button", { onClick: handleSend }, "Send")))));
};
export default App;
