import { useState } from 'react'
import { BrowserRouter as Router, Routes, Route, Link } from 'react-router-dom'
import CustomerManagement from './components/CustomerManagement'
import PolicyManagement from './components/PolicyManagement'
import ClaimsManagement from './components/ClaimsManagement'
import './InsuranceTheme.css'

function App() {
  const [activeTab, setActiveTab] = useState('customers')

  return (
    <Router>
      <div className="app-container">
        <nav className="navigation">
          <Link 
            to="/customers" 
            className={activeTab === 'customers' ? 'active' : ''}
            onClick={() => setActiveTab('customers')}
          >
            Customers
          </Link>
          <Link 
            to="/policies" 
            className={activeTab === 'policies' ? 'active' : ''}
            onClick={() => setActiveTab('policies')}
          >
            Policies
          </Link>
          <Link 
            to="/claims" 
            className={activeTab === 'claims' ? 'active' : ''}
            onClick={() => setActiveTab('claims')}
          >
            Claims
          </Link>
        </nav>

        <Routes>
          <Route path="/customers" element={<CustomerManagement />} />
          <Route path="/policies" element={<PolicyManagement />} />
          <Route path="/claims" element={<ClaimsManagement />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App
