import React from 'react'
import './styles/main.css'

const App = () => {
  return (
    <div className="app-container">
      <header className="app-header">
        <h1>Technical Solutions Hub</h1>
        <nav>
          <button className="nav-button">Articles</button>
          <button className="nav-button">Solutions</button>
          <button className="nav-button">Community</button>
        </nav>
      </header>
      <main className="content-area">
        <div className="search-container">
          <input type="text" placeholder="Search technical information..." />
          <button className="search-button">Search</button>
        </div>
        <div className="card-container">
          <div className="tech-card">
            <h3>Latest Articles</h3>
            <p>Browse our collection of technical articles</p>
          </div>
          <div className="tech-card">
            <h3>Popular Solutions</h3>
            <p>Find solutions to common technical problems</p>
          </div>
        </div>
      </main>
    </div>
  )
}

export default App