interface Property {
    id: number;
    title: string;
    price: number;
    bedrooms: number;
    bathrooms: number;
    sqft: number;
    location: string;
    image: string;
}

const properties: Property[] = [
    {
        id: 1,
        title: "Modern Downtown Apartment",
        price: 450000,
        bedrooms: 2,
        bathrooms: 2,
        sqft: 1200,
        location: "Downtown",
        image: "https://via.placeholder.com/300x200?text=Apartment"
    },
    {
        id: 2,
        title: "Suburban Family Home",
        price: 650000,
        bedrooms: 4,
        bathrooms: 3,
        sqft: 2500,
        location: "Suburbs",
        image: "https://via.placeholder.com/300x200?text=House"
    }
];

function renderProperties(properties: Property[]) {
    const app = document.getElementById('app');
    if (!app) return;

    app.innerHTML = `
        <header>
            <h1>Real Estate Listings</h1>
            <div class="search-container">
                <input type="text" placeholder="Search properties..." id="searchInput">
                <button id="searchButton">Search</button>
            </div>
        </header>
        <main>
            <div class="property-grid">
                ${properties.map(property => `
                    <div class="property-card">
                        <img src="${property.image}" alt="${property.title}">
                        <h3>${property.title}</h3>
                        <p>$${property.price.toLocaleString()}</p>
                        <p>${property.bedrooms} beds, ${property.bathrooms} baths, ${property.sqft} sqft</p>
                        <p>Location: ${property.location}</p>
                    </div>
                `).join('')}
            </div>
        </main>
        <footer>
            <p>© 2023 Real Estate Website</p>
        </footer>
    `;
}

// Initialize the app
renderProperties(properties);