import React from 'react'
import './App.css'
import ApartmentCard from './components/ApartmentCard'

const sampleApartments = [
  {
    id: 1,
    title: 'Luxury Downtown Apartment',
    location: 'New York, NY',
    price: 250,
    bedrooms: 2,
    image: 'https://images.unsplash.com/photo-1493809842364-78817add7ffb'
  },
  {
    id: 2,
    title: 'Cozy Beachfront Studio',
    location: 'Miami, FL',
    price: 180,
    bedrooms: 1,
    image: 'https://images.unsplash.com/photo-1502672260266-1c1ef2d93688'
  },
  {
    id: 3,
    title: 'Modern Loft',
    location: 'Chicago, IL',
    price: 200,
    bedrooms: 1,
    image: 'https://images.unsplash.com/photo-1505873242700-f289a29e1e0f'
  }
]

function App() {
  return (
    <div className="app">
      <h1>Apartment Rental Service</h1>
      <div className="content">
        <div className="apartments-list">
          {sampleApartments.map(apartment => (
            <ApartmentCard key={apartment.id} apartment={apartment} />
          ))}
        </div>
      </div>
    </div>
  )
}

export default App