import React from 'react'
import './ApartmentCard.css'

interface Apartment {
  id: number
  title: string
  location: string
  price: number
  bedrooms: number
  image: string
}

const ApartmentCard: React.FC<{ apartment: Apartment }> = ({ apartment }) => {
  return (
    <div className="apartment-card">
      <img src={apartment.image} alt={apartment.title} />
      <div className="apartment-details">
        <h3>{apartment.title}</h3>
        <p>{apartment.location}</p>
        <div className="features">
          <span>${apartment.price}/night</span>
          <span>{apartment.bedrooms} bedrooms</span>
        </div>
        <button className="book-button">Book Now</button>
      </div>
    </div>
  )
}

export default ApartmentCard