import { Link } from 'react-router-dom'
import '../styles/main.css'

function Navbar() {
  return (
    <nav style={{
      backgroundColor: 'var(--primary-color)',
      padding: '1rem',
      color: 'white'
    }}>
      <div style={{
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center',
        maxWidth: '1200px',
        margin: '0 auto'
      }}>
        <Link to="/" style={{ color: 'white', textDecoration: 'none', fontSize: '1.5rem' }}>
          Business Leaders
        </Link>
        <div style={{ display: 'flex', gap: '1rem' }}>
          <Link to="/services" style={{ color: 'white', textDecoration: 'none' }}>Services</Link>
          <Link to="/blog" style={{ color: 'white', textDecoration: 'none' }}>Blog</Link>
          <Link to="/podcasts" style={{ color: 'white', textDecoration: 'none' }}>Podcasts</Link>
        </div>
      </div>
    </nav>
  )
}

export default Navbar