import '../styles/main.css'

const blogPosts = [
  {
    id: 1,
    title: '5 Leadership Strategies for 2024',
    excerpt: 'Discover the top leadership approaches that will dominate this year',
    date: 'January 15, 2024',
    readTime: '5 min read'
  },
  {
    id: 2,
    title: 'Building Resilient Teams',
    excerpt: 'Learn how to create teams that thrive under pressure',
    date: 'February 2, 2024',
    readTime: '7 min read'
  },
  {
    id: 3,
    title: 'Digital Transformation in Business',
    excerpt: 'A guide to successfully navigating digital changes',
    date: 'March 10, 2024',
    readTime: '10 min read'
  }
]

function Blog() {
  return (
    <div className="blog-page" style={{ maxWidth: '1200px', margin: '0 auto', padding: '2rem' }}>
      <h1>Latest Articles</h1>
      <div style={{ display: 'grid', gap: '2rem' }}>
        {blogPosts.map(post => (
          <article key={post.id} style={{
            backgroundColor: 'white',
            padding: '1.5rem',
            borderRadius: '8px',
            boxShadow: '0 2px 4px rgba(0,0,0,0.1)'
          }}>
            <h2 style={{ color: 'var(--primary-color)' }}>{post.title}</h2>
            <p style={{ color: '#666' }}>{post.excerpt}</p>
            <div style={{ display: 'flex', justifyContent: 'space-between', marginTop: '1rem' }}>
              <span style={{ color: '#888' }}>{post.date}</span>
              <span style={{ color: '#888' }}>{post.readTime}</span>
            </div>
          </article>
        ))}
      </div>
    </div>
  )
}

export default Blog