import '../styles/main.css'

function Home() {
  return (
    <div className="home-page">
      <section style={{
        background: 'linear-gradient(rgba(95, 158, 160, 0.8), rgba(95, 158, 160, 0.8))',
        color: 'white',
        padding: '4rem 2rem',
        textAlign: 'center'
      }}>
        <h1>Transform Your Business Leadership</h1>
        <p style={{ maxWidth: '800px', margin: '0 auto', fontSize: '1.2rem' }}>
          Expert consulting services to elevate your leadership skills and business strategies
        </p>
      </section>

      <section style={{ padding: '2rem', maxWidth: '1200px', margin: '2rem auto' }}>
        <h2>Our Services</h2>
        <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fit, minmax(300px, 1fr))', gap: '2rem' }}>
          <div style={{ backgroundColor: 'white', padding: '1rem', borderRadius: '8px' }}>
            <h3>Workshops</h3>
            <p>Interactive sessions to develop leadership skills</p>
          </div>
          <div style={{ backgroundColor: 'white', padding: '1rem', borderRadius: '8px' }}>
            <h3>Online Classes</h3>
            <p>Flexible learning for busy professionals</p>
          </div>
          <div style={{ backgroundColor: 'white', padding: '1rem', borderRadius: '8px' }}>
            <h3>Consulting</h3>
            <p>Personalized business strategy development</p>
          </div>
        </div>
      </section>
    </div>
  )
}

export default Home