import { useState } from 'react'
import './styles/main.css'

function App() {
  const [activeTab, setActiveTab] = useState('compose')

  return (
    <div className="app">
      <header className="header">
        <h1>Email Platform</h1>
      </header>
      <nav className="tabs">
        <button 
          className={activeTab === 'compose' ? 'active' : ''}
          onClick={() => setActiveTab('compose')}
        >
          Compose
        </button>
        <button 
          className={activeTab === 'sent' ? 'active' : ''}
          onClick={() => setActiveTab('sent')}
        >
          Sent Emails
        </button>
        <button 
          className={activeTab === 'templates' ? 'active' : ''}
          onClick={() => setActiveTab('templates')}
        >
          Templates
        </button>
      </nav>
      <main className="content">
        {activeTab === 'compose' && <div>Compose Email Form</div>}
        {activeTab === 'sent' && <div>Sent Emails List</div>}
        {activeTab === 'templates' && <div>Email Templates</div>}
      </main>
    </div>
  )
}

export default App