import Chart from 'chart.js/auto'

export function initDashboard() {
  const app = document.getElementById('app')!
  app.innerHTML = `
    <div class="dashboard">
      <div class="panel real-time">
        <h2>Real-time Data</h2>
        <div id="real-time-data"></div>
      </div>
      <div class="panel historical">
        <h2>Historical Query</h2>
        <div id="historical-controls"></div>
      </div>
      <div class="chart-container">
        <canvas id="solar-chart"></canvas>
      </div>
    </div>
  `

  // Initialize chart
  const ctx = document.getElementById('solar-chart') as HTMLCanvasElement
  new Chart(ctx, {
    type: 'line',
    data: {
      labels: [],
      datasets: [
        {
          label: 'Solar Generation',
          data: [],
          borderColor: 'rgb(75, 192, 192)',
          tension: 0.1
        }
      ]
    }
  })

  // Simulate real-time data updates
  setInterval(updateRealTimeData, 1000)
}

function updateRealTimeData() {
  // This would be replaced with actual API calls
  const dataElement = document.getElementById('real-time-data')!
  dataElement.innerHTML = `
    <p>Power Generation: ${(Math.random() * 5).toFixed(2)} kW</p>
    <p>Power Consumption: ${(Math.random() * 3).toFixed(2)} kW</p>
    <p>Battery Percentage: ${Math.floor(Math.random() * 100)}%</p>
  `
}