# Internship Portal

A full-stack application connecting students with companies for internship opportunities.

## Features
- Student panel for browsing and applying to internships
- Company panel for posting internship opportunities
- Email notification system
- Responsive design with mint cream background and teal accents

## Technologies
- Frontend: React, TypeScript, Vite
- Backend: Express, Node.js
- Styling: CSS
- Email: Nodemailer

## Setup

1. Clone the repository
2. Install dependencies:
   ```bash
   npm install
   ```
3. Create a `.env` file based on `.env.example`
4. Start development servers:
   ```bash
   npm run dev       # Frontend (port 3000)
   npm run server    # Backend (port 5000)
   ```

## Environment Variables

See `.env.example` for required variables.

## Available Scripts

- `dev`: Start frontend development server
- `build`: Build production frontend
- `preview`: Preview production build
- `server`: Start backend server