import express from 'express';
import cors from 'cors';
import nodemailer from 'nodemailer';
import { config } from './config';
import { DataService } from './services/dataService';

const app = express();

app.use(cors());
app.use(express.json());

// Email transporter setup
const transporter = nodemailer.createTransport(config.email);

// Routes
app.get('/api', (req, res) => {
  res.json({ message: 'Internship Portal API' });
});

// Student routes
app.get('/api/student/internships', (req, res) => {
  const internships = DataService.getInternships();
  res.json(internships);
});

app.post('/api/student/applications', (req, res) => {
  try {
    const application = DataService.createApplication(req.body);
    res.status(201).json(application);
  } catch (error) {
    res.status(400).json({ error: 'Invalid application data' });
  }
});

// Company routes
app.post('/api/company/internships', (req, res) => {
  try {
    const internship = DataService.createInternship(req.body);
    res.status(201).json(internship);
  } catch (error) {
    res.status(400).json({ error: 'Invalid internship data' });
  }
});

app.post('/api/register', (req, res) => {
  try {
    const user = DataService.createUser(req.body);
    res.status(201).json(user);
  } catch (error) {
    res.status(400).json({ error: 'Invalid user data' });
  }
});

// Error handling
app.use((err: any, req: any, res: any, next: any) => {
  console.error(err.stack);
  res.status(500).send('Something broke!');
});

app.listen(config.server.port, () => {
  console.log(`Server running on http://localhost:${config.server.port}`);
});