import { User, Internship, Application } from '../models';

// Temporary in-memory data storage
const users: User[] = [];
const internships: Internship[] = [];
const applications: Application[] = [];

export const DataService = {
  // User methods
  createUser(user: Omit<User, 'id'>): User {
    const newUser = { ...user, id: Date.now().toString() };
    users.push(newUser);
    return newUser;
  },

  getUserById(id: string): User | undefined {
    return users.find(user => user.id === id);
  },

  // Internship methods
  createInternship(internship: Omit<Internship, 'id' | 'applications'>): Internship {
    const newInternship = { 
      ...internship, 
      id: Date.now().toString(),
      applications: [] 
    };
    internships.push(newInternship);
    return newInternship;
  },

  getInternships(): Internship[] {
    return [...internships];
  },

  // Application methods
  createApplication(application: Omit<Application, 'id'>): Application {
    const newApplication = { ...application, id: Date.now().toString() };
    applications.push(newApplication);
    return newApplication;
  }
};