import React from 'react';
import { BrowserRouter as Router, Routes, Route, Link } from 'react-router-dom';
import './App.css';

const App: React.FC = () => {
  return (
    <Router>
      <nav style={{ backgroundColor: 'slategray', padding: '1rem' }}>
        <ul style={{ display: 'flex', listStyle: 'none', gap: '1rem' }}>
          <li><Link to="/" style={{ color: 'white' }}>Home</Link></li>
          <li><Link to="/athlete/register" style={{ color: 'white' }}>Athlete Registration</Link></li>
          <li><Link to="/organization/register" style={{ color: 'white' }}>Organization Registration</Link></li>
          <li><Link to="/jobs" style={{ color: 'white' }}>Job Board</Link></li>
        </ul>
      </nav>
      <div style={{ padding: '2rem' }}>
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/athlete/register" element={<AthleteRegister />} />
          <Route path="/organization/register" element={<OrganizationRegister />} />
          <Route path="/jobs" element={<JobBoard />} />
        </Routes>
      </div>
    </Router>
  );
};

// Placeholder components
const Home = () => (
  <div>
    <h2>Welcome to Sports Recruitment Platform</h2>
    <p>Connect athletes with sports organizations</p>
  </div>
);

const AthleteRegister = () => (
  <div>
    <h2>Athlete Registration</h2>
    {/* Registration form will be implemented here */}
  </div>
);

const OrganizationRegister = () => (
  <div>
    <h2>Organization Registration</h2>
    {/* Registration form will be implemented here */}
  </div>
);

const JobBoard = () => (
  <div>
    <h2>Job Board</h2>
    {/* Job listings will be implemented here */}
  </div>
);

export default App;