import React from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Navbar from './components/Navbar'
import Home from './pages/Home'
import Courses from './pages/Courses'
import Enrollment from './pages/Enrollment'
import Timetable from './pages/Timetable'
import Contact from './pages/Contact'
import './css/main.css'

function App() {
  return (
    <Router>
      <div className="app" style={{ backgroundColor: 'lavender', minHeight: '100vh' }}>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/courses" element={<Courses />} />
          <Route path="/enroll" element={<Enrollment />} />
          <Route path="/timetable" element={<Timetable />} />
          <Route path="/contact" element={<Contact />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App