import React, { useState } from 'react'

const Contact: React.FC = () => {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    subject: '',
    message: ''
  })

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target
    setFormData(prev => ({ ...prev, [name]: value }))
  }

  return (
    <div className="page-container">
      <h1>Contact Us</h1>
      <div className="contact-content">
        <div className="contact-info" style={{ border: '2px solid indigo', padding: '1rem', marginBottom: '1rem' }}>
          <h3>Global Institute of Information Security</h3>
          <p>Email: info@gis-institute.edu</p>
          <p>Phone: +1 (555) 123-4567</p>
          <p>Address: 123 Security Way, Tech City</p>
        </div>
        <form style={{ maxWidth: '500px', margin: '0 auto' }}>
          <div className="form-group">
            <label>Name:</label>
            <input 
              type="text" 
              name="name" 
              value={formData.name} 
              onChange={handleChange} 
              required 
            />
          </div>
          <div className="form-group">
            <label>Email:</label>
            <input 
              type="email" 
              name="email" 
              value={formData.email} 
              onChange={handleChange} 
              required 
            />
          </div>
          <div className="form-group">
            <label>Subject:</label>
            <input 
              type="text" 
              name="subject" 
              value={formData.subject} 
              onChange={handleChange} 
              required 
            />
          </div>
          <div className="form-group">
            <label>Message:</label>
            <textarea 
              name="message" 
              value={formData.message} 
              onChange={handleChange} 
              required 
            />
          </div>
          <button 
            type="submit" 
            style={{ backgroundColor: 'indigo', color: 'white' }}
          >
            Send Message
          </button>
        </form>
      </div>
    </div>
  )
}

export default Contact