import React from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import RegistrationForm from './components/RegistrationForm';
import StudentProfile from './components/StudentProfile';
import MatchingResults from './components/MatchingResults';
import Navigation from './components/Navigation';
import './styles/main.css';

const App = () => {
  return (
    <Router>
      <div className="app-container" style={{ background: 'azure' }}>
        <header className="app-header" style={{ backgroundColor: 'midnightblue', color: 'white' }}>
          <h1>Student Portal</h1>
          <Navigation />
        </header>
        <main className="app-main">
          <Routes>
            <Route path="/register" element={<RegistrationForm />} />
            <Route path="/profile" element={<StudentProfile />} />
            <Route path="/matches" element={<MatchingResults />} />
            <Route path="/" element={<div>Welcome to Student Portal</div>} />
          </Routes>
        </main>
        <footer className="app-footer" style={{ backgroundColor: 'midnightblue', color: 'white' }}>
          © 2023 Student Portal
        </footer>
      </div>
    </Router>
  );
};

export default App;