import React, { useEffect, useState } from 'react';
import { useLocation } from 'react-router-dom';
import { findMatchingProviders } from '../services/matchingService';
import './styles/main.css';

const MatchingResults = () => {
  const location = useLocation();
  const [providers, setProviders] = useState<any[]>([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    // In a real app, we would get the profile data from state or API
    const mockProfile = {
      qualifications: 'Computer Science',
      interests: 'Web Development',
      location: 'New York'
    };
    
    const results = findMatchingProviders(mockProfile);
    setProviders(results);
    setLoading(false);
  }, []);

  if (loading) return <div className="loading">Loading matches...</div>;

  return (
    <div className="matching-results">
      <h2 className="results-title">Recommended Training Providers</h2>
      <div className="providers-list">
        {providers.map(provider => (
          <div key={provider.id} className="provider-card">
            <h3>{provider.name}</h3>
            <p><strong>Location:</strong> {provider.location}</p>
            <p><strong>Programs:</strong> {provider.programs.join(', ')}</p>
            <div className="match-score">
              <span>Match: {provider.matchScore}%</span>
              <div className="score-bar">
                <div 
                  className="score-fill" 
                  style={{ width: `${provider.matchScore}%` }}
                ></div>
              </div>
            </div>
            <button className="contact-btn">Contact Provider</button>
          </div>
        ))}
      </div>
    </div>
  );
};

export default MatchingResults;