import { useState } from 'react'
import './styles.css'
import WasteItem from './components/WasteItem'
import RecyclingBin from './components/RecyclingBin'

const WASTE_ITEMS = [
  { type: 'plastic', image: 'https://example.com/plastic-bottle.png' },
  { type: 'paper', image: 'https://example.com/newspaper.png' },
  { type: 'glass', image: 'https://example.com/glass-bottle.png' },
  { type: 'metal', image: 'https://example.com/can.png' }
]

const BINS = [
  { type: 'plastic', accepts: ['plastic'] },
  { type: 'paper', accepts: ['paper'] },
  { type: 'glass', accepts: ['glass'] },
  { type: 'metal', accepts: ['metal'] }
]

function App() {
  const [score, setScore] = useState(0)
  const [items] = useState(WASTE_ITEMS)

  const handleDrop = (itemType: string, binType: string) => {
    if (BINS.find(bin => bin.type === binType)?.accepts.includes(itemType)) {
      setScore(prev => prev + 10)
    } else {
      setScore(prev => Math.max(0, prev - 5))
    }
  }

  return (
    <div className="app" style={{ background: 'seashell' }}>
      <h1>Recycling Adventure</h1>
      <div className="game-area">
        <div className="waste-items">
          {items.map((item, index) => (
            <WasteItem
              key={index}
              type={item.type}
              image={item.image}
              style={{ position: 'absolute', left: `${100 + index * 80}px`, top: '50px' }}
              onDragStart={(type) => console.log('Dragging:', type)}
            />
          ))}
        </div>
        <div className="bins-container">
          {BINS.map(bin => (
            <RecyclingBin
              key={bin.type}
              type={bin.type}
              accepts={bin.accepts}
              onDrop={(itemType) => handleDrop(itemType, bin.type)}
            />
          ))}
        </div>
      </div>
      <div className="score" style={{ color: 'crimson' }}>
        Score: {score}
      </div>
    </div>
  )
}

export default App