import { CSSProperties } from 'react'

interface WasteItemProps {
  type: string
  image: string
  style?: CSSProperties
  onDragStart: (type: string) => void
}

export default function WasteItem({ type, image, style, onDragStart }: WasteItemProps) {
  return (
    <div 
      className="waste-item"
      draggable
      onDragStart={() => onDragStart(type)}
      style={{
        width: '60px',
        height: '60px',
        backgroundImage: `url(${image})`,
        backgroundSize: 'contain',
        backgroundRepeat: 'no-repeat',
        cursor: 'grab',
        ...style
      }}
    />
  )
}