import { BrowserRouter as Router, Routes, Route, Link } from 'react-router-dom'
import './styles/main.css'

function App() {
  return (
    <div className="app">
      <Router>
        <header>
          <h1>Agriculture Information Portal</h1>
        </header>
        <nav>
          <Link to="/">Home</Link>
          <Link to="/news">News</Link>
          <Link to="/products">Products</Link>
          <Link to="/weather">Weather</Link>
        </nav>
        <main>
          <Routes>
            <Route path="/" element={<HomePage />} />
            <Route path="/news" element={<NewsPage />} />
            <Route path="/products" element={<ProductsPage />} />
            <Route path="/weather" element={<WeatherPage />} />
          </Routes>
        </main>
        <footer>
          <p>© 2024 Agriculture Information Portal</p>
        </footer>
      </Router>
    </div>
  )
}

function HomePage() {
  return (
    <div className="home-content">
      <h2>Welcome to Agriculture Information Portal</h2>
      <p>
        Your comprehensive source for agricultural news, farm product information,
        and weather forecasts to help you make informed decisions.
      </p>
      <div className="features">
        <div className="feature-card">
          <h3>Latest News</h3>
          <p>Stay updated with the latest developments in agriculture</p>
        </div>
        <div className="feature-card">
          <h3>Farm Products</h3>
          <p>Explore information about various agricultural products</p>
        </div>
        <div className="feature-card">
          <h3>Weather Forecast</h3>
          <p>Get accurate weather predictions for your farming needs</p>
        </div>
      </div>
    </div>
  )
}

function NewsPage() {
  const newsItems = [
    {
      id: 1,
      title: "New Sustainable Farming Techniques",
      summary: "Researchers develop innovative methods to increase crop yields while reducing environmental impact",
      date: "2024-03-15"
    },
    {
      id: 2,
      title: "Global Grain Market Update",
      summary: "Recent weather patterns affect wheat production in key regions",
      date: "2024-03-10"
    },
    {
      id: 3,
      title: "Organic Farming Grants Available",
      summary: "Government announces funding opportunities for small-scale organic farmers",
      date: "2024-03-05"
    }
  ]

  return (
    <div className="news-content">
      <h2>Agricultural News</h2>
      <div className="news-list">
        {newsItems.map(item => (
          <article key={item.id} className="news-card">
            <h3>{item.title}</h3>
            <p>{item.summary}</p>
            <time dateTime={item.date}>{item.date}</time>
          </article>
        ))}
      </div>
    </div>
  )
}

function ProductsPage() {
  const products = [
    {
      id: 1,
      name: "Organic Wheat",
      category: "Grains",
      price: "$5.99/kg",
      description: "High-quality organic wheat grown with sustainable practices"
    },
    {
      id: 2,
      name: "Fresh Tomatoes",
      category: "Vegetables",
      price: "$3.49/kg",
      description: "Vine-ripened tomatoes with exceptional flavor"
    },
    {
      id: 3,
      name: "Free-range Eggs",
      category: "Dairy",
      price: "$4.99/dozen",
      description: "Eggs from pasture-raised chickens"
    }
  ]

  return (
    <div className="products-content">
      <h2>Farm Products</h2>
      <div className="product-filters">
        <button>All</button>
        <button>Grains</button>
        <button>Vegetables</button>
        <button>Dairy</button>
      </div>
      <div className="product-list">
        {products.map(product => (
          <div key={product.id} className="product-card">
            <h3>{product.name}</h3>
            <span className="product-category">{product.category}</span>
            <p>{product.description}</p>
            <span className="product-price">{product.price}</span>
          </div>
        ))}
      </div>
    </div>
  )
}

function WeatherPage() {
  const forecasts = [
    {
      day: "Monday",
      condition: "Sunny",
      high: 28,
      low: 16,
      precipitation: "0%"
    },
    {
      day: "Tuesday",
      condition: "Partly Cloudy",
      high: 25,
      low: 17,
      precipitation: "10%"
    },
    {
      day: "Wednesday",
      condition: "Rain",
      high: 20,
      low: 15,
      precipitation: "80%"
    },
    {
      day: "Thursday",
      condition: "Cloudy",
      high: 22,
      low: 14,
      precipitation: "20%"
    }
  ]

  return (
    <div className="weather-content">
      <h2>5-Day Weather Forecast</h2>
      <div className="forecast-container">
        {forecasts.map((forecast, index) => (
          <div key={index} className="forecast-card">
            <h3>{forecast.day}</h3>
            <div className="weather-condition">{forecast.condition}</div>
            <div className="temperature">
              <span className="high">{forecast.high}°C</span>
              <span className="low">{forecast.low}°C</span>
            </div>
            <div className="precipitation">Precipitation: {forecast.precipitation}</div>
          </div>
        ))}
      </div>
    </div>
  )
}

export default App