"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const app = (0, express_1.default)();
const port = 3000;
// Set up static files and views
app.use(express_1.default.static(path_1.default.join(__dirname, 'public')));
app.set('views', path_1.default.join(__dirname, 'views'));
app.set('view engine', 'ejs');
// API Routes
app.get('/api/weather', (req, res) => {
    // Mock data - in production this would come from sensors/API
    const mockData = {
        temperature: (Math.random() * 30 + 10).toFixed(1),
        humidity: (Math.random() * 50 + 30).toFixed(1),
        aqi: Math.floor(Math.random() * 300),
        aqiHistory: Array.from({ length: 14 }, () => Math.floor(Math.random() * 300))
    };
    res.json(mockData);
});
// Alert system endpoint
app.post('/api/alerts', (req, res) => {
    // In production, this would trigger actual alerts
    res.json({ status: 'success', message: 'Alert triggered' });
});
// Basic route
app.get('/', (req, res) => {
    res.render('index', {
        title: 'Environmental Warning System'
    });
});
app.listen(port, () => {
    console.log(`Server running at http://localhost:${port}`);
});
