import express, { Request, Response } from 'express';
import path from 'path';

const app = express();
const port = 3000;

// Set up static files and views
app.use(express.static(path.join(__dirname, 'public')));
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

// API Routes
app.get('/api/weather', (req: Request, res: Response) => {
    // Mock data - in production this would come from sensors/API
    const mockData = {
        temperature: (Math.random() * 30 + 10).toFixed(1),
        humidity: (Math.random() * 50 + 30).toFixed(1),
        aqi: Math.floor(Math.random() * 300),
        aqiHistory: Array.from({length: 14}, () => Math.floor(Math.random() * 300))
    };
    res.json(mockData);
});

// Alert system endpoint
app.post('/api/alerts', (req: Request, res: Response) => {
    // In production, this would trigger actual alerts
    res.json({status: 'success', message: 'Alert triggered'});
});

// Basic route
app.get('/', (req: Request, res: Response) => {
    res.render('index', {
        title: 'Environmental Warning System'
    });
});

app.listen(port, () => {
    console.log(`Server running at http://localhost:${port}`);
});