"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const article_1 = require("../models/article");
const router = (0, express_1.Router)();
// Get all articles
router.get('/', (req, res) => {
    const articles = (0, article_1.getArticles)();
    res.render('articles/index', { articles });
});
// Get article by ID
router.get('/:id', (req, res) => {
    const article = (0, article_1.getArticleById)(req.params.id);
    if (!article) {
        return res.status(404).render('404');
    }
    res.render('articles/show', { article });
});
// Search articles
router.get('/search', (req, res) => {
    const query = req.query.q;
    if (!query) {
        return res.redirect('/articles');
    }
    const results = (0, article_1.searchArticles)(query);
    res.render('articles/search', { results, query });
});
// Create new article
router.post('/', (req, res) => {
    try {
        const newArticle = (0, article_1.createArticle)(req.body);
        res.redirect(`/articles/${newArticle.id}`);
    }
    catch (error) {
        res.status(400).render('500');
    }
});
// Get articles by category
router.get('/category/:category', (req, res) => {
    const articles = (0, article_1.getArticlesByCategory)(req.params.category);
    res.render('articles/category', {
        articles,
        category: req.params.category
    });
});
exports.default = router;
