import express from 'express';
import path from 'path';
import { getArticles } from './models/article';

const app = express();
const PORT = 3000;

// Set up static files and view engine
app.use(express.static(path.join(__dirname, 'public')));
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

// Middleware
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Import routes
import articlesRouter from './routes/articles';

// Configure routes
app.use('/articles', articlesRouter);

// Home route
app.get('/', (req, res) => {
    const featuredArticles = getArticles().slice(0, 3);
    res.render('index', {
        title: 'Health Blog',
        colors: {
            background: 'mistyrose',
            components: 'firebrick'
        },
        featuredArticles
    });
});

// Error handling
app.use((req, res) => {
    res.status(404).render('404');
});

app.use((err: Error, req: express.Request, res: express.Response) => {
    console.error(err.stack);
    res.status(500).render('500');
});

// Start server
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
});