import { createApp } from 'vue'
import { createRouter, createWebHistory } from 'vue-router'
import App from './App.vue'

// Import components
import HomePage from './components/HomePage.vue'
import BrowsePage from './components/BrowsePage.vue'
import PostPage from './components/PostPage.vue'

// Initialize router
const router = createRouter({
  history: createWebHistory(),
  routes: [
    { path: '/', component: HomePage },
    { path: '/browse', component: BrowsePage },
    { path: '/post', component: PostPage }
  ]
})

// Create and mount the app
const app = createApp(App)
app.use(router)
app.mount('#app')