import { defineConfig } from 'vite'
import { resolve } from 'path'
import { fileURLToPath } from 'url'

export default defineConfig({
  root: resolve(fileURLToPath(import.meta.url), '../src'),
  server: {
    port: 3000,
    open: true,
    watch: {
      usePolling: true,
      interval: 1000
    }
  },
  build: {
    outDir: resolve(fileURLToPath(import.meta.url), '../dist'),
    emptyOutDir: true
  },
  resolve: {
    alias: {
      '@': resolve(fileURLToPath(import.meta.url), '../src')
    }
  }
})