import { useState } from 'react'
import './App.css'

function App() {
  const [searchTerm, setSearchTerm] = useState('')

  // Sample biography data
  const biography = {
    name: "John Doe",
    birthDate: "January 1, 1980",
    occupation: "Scientist",
    summary: "A renowned scientist with numerous contributions to the field.",
    experiences: [
      { year: "2005-2010", title: "Research Assistant", description: "Worked on groundbreaking research" },
      { year: "2010-2015", title: "Lead Scientist", description: "Led a team of researchers" }
    ],
    achievements: [
      "Nobel Prize in Physics (2018)",
      "Published 50+ research papers"
    ]
  }

  return (
    <div className="app">
      <header>
        <h1>{biography.name}</h1>
        <div className="search">
          <input
            type="text"
            placeholder="Search biography..."
            value={searchTerm}
            onChange={(e) => setSearchTerm(e.target.value)}
          />
        </div>
      </header>

      <main>
        <section className="basic-info">
          <h2>Basic Information</h2>
          <p><strong>Born:</strong> {biography.birthDate}</p>
          <p><strong>Occupation:</strong> {biography.occupation}</p>
          <p>{biography.summary}</p>
        </section>

        <section className="experiences">
          <h2>Life Experiences</h2>
          {biography.experiences.map((exp, index) => (
            <div key={index} className="experience">
              <h3>{exp.title} ({exp.year})</h3>
              <p>{exp.description}</p>
            </div>
          ))}
        </section>

        <section className="achievements">
          <h2>Achievements</h2>
          <ul>
            {biography.achievements.map((achievement, index) => (
              <li key={index}>{achievement}</li>
            ))}
          </ul>
        </section>
      </main>
    </div>
  )
}

export default App