import Link from 'next/link'
import { useAuth } from '../context/AuthContext'

export default function Navigation() {
  const { user, isAdmin, logout } = useAuth()

  return (
    <header style={{ backgroundColor: '#228B22', color: 'white', padding: '1rem' }}>
      <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <h1 style={{ margin: 0 }}>
          <Link href="/" passHref>
            <a style={{ color: 'white', textDecoration: 'none' }}>Engineering Tools Directory</a>
          </Link>
        </h1>
        <nav>
          {user ? (
            <div style={{ display: 'flex', gap: '1rem' }}>
              {isAdmin && (
                <Link href="/admin" passHref>
                  <button>Admin</button>
                </Link>
              )}
              <button onClick={logout}>Logout</button>
            </div>
          ) : (
            <div style={{ display: 'flex', gap: '1rem' }}>
              <Link href="/login" passHref>
                <button>Login</button>
              </Link>
              <Link href="/register" passHref>
                <button>Register</button>
              </Link>
            </div>
          )}
        </nav>
      </div>
    </header>
  )
}