import Link from 'next/link'

interface Tool {
  id: string
  name: string
  description: string
  price: string
  rating: number
}

export default function ToolCard({ tool }: { tool: Tool }) {
  return (
    <div style={{
      border: '1px solid #228B22',
      borderRadius: '8px',
      padding: '1rem',
      marginBottom: '1rem'
    }}>
      <h3>{tool.name}</h3>
      <p>{tool.description}</p>
      <div style={{ display: 'flex', justifyContent: 'space-between' }}>
        <span>Price: {tool.price}</span>
        <span>Rating: {'★'.repeat(tool.rating)}</span>
      </div>
      <Link href={`/tools/${tool.id}`} passHref>
        <button style={{ marginTop: '0.5rem', width: '100%' }}>View Details</button>
      </Link>
    </div>
  )
}