import { useEffect } from 'react'
import { useAuth } from '../context/AuthContext'
import { useRouter } from 'next/router'
import Navigation from '../components/Navigation'

export default function AdminDashboard() {
  const { user, isAdmin } = useAuth()
  const router = useRouter()

  useEffect(() => {
    if (!isAdmin) {
      router.push('/')
    }
  }, [isAdmin, router])

  if (!isAdmin) {
    return null
  }

  return (
    <div>
      <Navigation />
      <div style={{ padding: '2rem' }}>
        <h1>Admin Dashboard</h1>
      <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fill, minmax(300px, 1fr))', gap: '1rem' }}>
        <div style={{ border: '1px solid #228B22', borderRadius: '4px', padding: '1rem' }}>
          <h2>Manage Tools</h2>
          <p>Add, edit or remove engineering tools</p>
        </div>
        <div style={{ border: '1px solid #228B22', borderRadius: '4px', padding: '1rem' }}>
          <h2>Manage Users</h2>
          <p>View and manage user accounts</p>
        </div>
        <div style={{ border: '1px solid #228B22', borderRadius: '4px', padding: '1rem' }}>
          <h2>Moderate Content</h2>
          <p>Review and moderate comments/ratings</p>
        </div>
      </div>
    </div>
  )
}