import '../public/styles.css';

class DiagramMaker {
    private container: HTMLElement;
    private nodes: HTMLElement[] = [];
    private selectedNode: HTMLElement | null = null;
    private offsetX: number = 0;
    private offsetY: number = 0;

    constructor() {
        this.container = document.createElement('div');
        this.container.className = 'diagram-container';
        document.getElementById('app')?.appendChild(this.container);

        this.setupToolbar();
        this.setupEventListeners();
    }

    private setupToolbar() {
        const toolbar = document.createElement('div');
        toolbar.className = 'toolbar';
        
        const addButton = document.createElement('button');
        addButton.textContent = 'Add Node';
        addButton.addEventListener('click', () => this.addNode());
        
        toolbar.appendChild(addButton);
        document.getElementById('app')?.prepend(toolbar);
    }

    private setupEventListeners() {
        this.container.addEventListener('mousedown', this.handleMouseDown.bind(this));
        this.container.addEventListener('mousemove', this.handleMouseMove.bind(this));
        this.container.addEventListener('mouseup', this.handleMouseUp.bind(this));
    }

    private handleMouseDown(e: MouseEvent) {
        if (e.target instanceof HTMLElement && e.target.classList.contains('node')) {
            this.selectedNode = e.target;
            const rect = this.selectedNode.getBoundingClientRect();
            this.offsetX = e.clientX - rect.left;
            this.offsetY = e.clientY - rect.top;
        }
    }

    private handleMouseMove(e: MouseEvent) {
        if (this.selectedNode) {
            this.selectedNode.style.left = `${e.clientX - this.offsetX}px`;
            this.selectedNode.style.top = `${e.clientY - this.offsetY}px`;
        }
    }

    private handleMouseUp() {
        this.selectedNode = null;
    }

    public addNode() {
        const node = document.createElement('div');
        node.className = 'node';
        node.textContent = `Node ${this.nodes.length + 1}`;
        node.style.left = '100px';
        node.style.top = '100px';
        this.container.appendChild(node);
        this.nodes.push(node);
    }
}

new DiagramMaker();