import React from 'react'
import Chessboard from 'chessboardjsx'
import { Chess } from 'chess.js'


const App: React.FC = () => {
  const [game, setGame] = React.useState(new Chess())

  return (
    <div className="app-container">
      <h1>Chess App</h1>
      <div className="chessboard-container">
        <Chessboard
          position={game.fen()}
          onDrop={({ sourceSquare, targetSquare }) => {
            try {
              const move = game.move({
                from: sourceSquare,
                to: targetSquare,
                promotion: 'q'
              })
              setGame(new Chess(game.fen()))
            } catch (e) {
              return false
            }
          }}
        />
      </div>
    </div>
  )
}

export default App