import { useState } from 'react';
import Head from 'next/head';

type Animal = {
  id: number;
  name: string;
  colorCode: string;
  detected: boolean;
};

export default function AnimalSpotter() {
  const [animals, setAnimals] = useState<Animal[]>([
    { id: 1, name: 'Bear', colorCode: '#8B4513', detected: false },
    { id: 2, name: 'Wolf', colorCode: '#808080', detected: false },
    { id: 3, name: 'Deer', colorCode: '#CD853F', detected: false },
  ]);
  const [phoneNumber, setPhoneNumber] = useState('');

  const handleDetection = (id: number) => {
    setAnimals(animals.map(animal => 
      animal.id === id ? { ...animal, detected: true } : animal
    ));
    // In a real app, this would trigger the SMS alert
    console.log(`Alert sent for ${animals.find(a => a.id === id)?.name}`);
  };

  return (
    <div style={{ backgroundColor: '#ffe4e1', minHeight: '100vh', padding: '20px' }}>
      <Head>
        <title>Wild Animal Spotter</title>
        <meta name="description" content="Wild animal detection and alert system" />
      </Head>

      <h1 style={{ color: 'firebrick' }}>Wild Animal Spotter</h1>
      
      <div style={{ marginBottom: '20px' }}>
        <h2>Set Alert Preferences</h2>
        <input
          type="tel"
          placeholder="Enter phone number for alerts"
          value={phoneNumber}
          onChange={(e) => setPhoneNumber(e.target.value)}
          style={{ padding: '8px', border: '1px solid firebrick' }}
        />
      </div>

      <div>
        <h2>Animal Detection Panel</h2>
        <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fill, minmax(200px, 1fr))', gap: '20px' }}>
          {animals.map(animal => (
            <div 
              key={animal.id} 
              style={{ 
                padding: '15px', 
                border: `2px solid ${animal.colorCode}`,
                backgroundColor: animal.detected ? '#ffcccc' : 'white'
              }}
            >
              <h3 style={{ color: animal.colorCode }}>{animal.name}</h3>
              <button 
                onClick={() => handleDetection(animal.id)}
                style={{
                  backgroundColor: 'firebrick',
                  color: 'white',
                  padding: '8px 12px',
                  border: 'none',
                  cursor: 'pointer'
                }}
              >
                {animal.detected ? 'Alert Sent' : 'Detect Animal'}
              </button>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}