// Sample data for ringtones and wallpapers
const sampleRingtones = [
  { id: 1, name: "Classic Ring", category: "classic", downloads: 1245 },
  { id: 2, name: "Jazz Tone", category: "jazz", downloads: 892 },
  { id: 3, name: "Nature Sounds", category: "nature", downloads: 2103 }
];

const sampleWallpapers = [
  { id: 1, name: "Mountain View", category: "nature", downloads: 3456 },
  { id: 2, name: "Abstract Art", category: "art", downloads: 1234 },
  { id: 3, name: "City Lights", category: "urban", downloads: 2789 }
];

// DOM elements
const contentGrid = document.querySelector('.content-grid') as HTMLElement;
const searchInput = document.querySelector('.search-bar input') as HTMLInputElement;
const searchButton = document.querySelector('.search-bar button') as HTMLButtonElement;
const categoryButtons = document.querySelectorAll('.category-btn');

// Current displayed content
let currentContent: 'ringtones' | 'wallpapers' = 'ringtones';

// Render content based on current selection
function renderContent(items: any[]) {
  contentGrid.innerHTML = '';
  
  items.forEach(item => {
    const card = document.createElement('div');
    card.className = 'content-card';
    card.innerHTML = `
      <h3>${item.name}</h3>
      <p>Category: ${item.category}</p>
      <p>Downloads: ${item.downloads}</p>
      <button class="download-btn" data-id="${item.id}">Download</button>
    `;
    contentGrid.appendChild(card);
  });

  // Add download event listeners
  document.querySelectorAll('.download-btn').forEach(btn => {
    btn.addEventListener('click', handleDownload);
  });
}

// Handle download button click
function handleDownload(event: Event) {
  const button = event.target as HTMLButtonElement;
  const id = button.dataset.id;
  alert(`Downloading ${currentContent.slice(0, -1)} with ID: ${id}`);
}

// Initialize the app
function init() {
  // Set default content
  renderContent(sampleRingtones);

  // Category button event listeners
  categoryButtons.forEach((btn, index) => {
    btn.addEventListener('click', () => {
      currentContent = index === 0 ? 'ringtones' : 'wallpapers';
      renderContent(currentContent === 'ringtones' ? sampleRingtones : sampleWallpapers);
    });
  });

  // Search functionality
  searchButton.addEventListener('click', () => {
    const searchTerm = searchInput.value.toLowerCase();
    const items = currentContent === 'ringtones' ? sampleRingtones : sampleWallpapers;
    const filtered = items.filter(item => 
      item.name.toLowerCase().includes(searchTerm) || 
      item.category.toLowerCase().includes(searchTerm)
    );
    renderContent(filtered);
  });
}

// Start the app
init();