import React from 'react';

const TicketSearch = () => {
  return (
    <div style={{
      backgroundColor: 'snow',
      color: 'dimgray',
      padding: '20px',
      borderRadius: '8px',
      boxShadow: '0 2px 4px rgba(0,0,0,0.1)'
    }}>
      <h2 style={{ 
        borderBottom: '1px solid dimgray',
        paddingBottom: '10px',
        marginBottom: '20px'
      }}>
        Book Your Journey
      </h2>
      
      <form style={{ display: 'grid', gap: '15px' }}>
        <div style={{ display: 'flex', flexDirection: 'column' }}>
          <label style={{ marginBottom: '5px', fontWeight: 'bold' }}>Transport Type</label>
          <select 
            style={{
              padding: '8px',
              border: '1px solid dimgray',
              borderRadius: '4px',
              backgroundColor: 'white'
            }}
          >
            <option value="bus">Bus</option>
            <option value="train">Train</option>
          </select>
        </div>

        <div style={{ display: 'flex', flexDirection: 'column' }}>
          <label style={{ marginBottom: '5px', fontWeight: 'bold' }}>Departure</label>
          <input 
            type="text" 
            placeholder="From" 
            style={{
              padding: '8px',
              border: '1px solid dimgray',
              borderRadius: '4px'
            }}
          />
        </div>

        <div style={{ display: 'flex', flexDirection: 'column' }}>
          <label style={{ marginBottom: '5px', fontWeight: 'bold' }}>Arrival</label>
          <input 
            type="text" 
            placeholder="To" 
            style={{
              padding: '8px',
              border: '1px solid dimgray',
              borderRadius: '4px'
            }}
          />
        </div>

        <button 
          type="submit"
          style={{
            padding: '10px',
            backgroundColor: 'dimgray',
            color: 'white',
            border: 'none',
            borderRadius: '4px',
            cursor: 'pointer',
            marginTop: '10px'
          }}
        >
          Search Tickets
        </button>
      </form>
    </div>
  );
};

export default TicketSearch;