import express from 'express';
import path from 'path';

const app = express();
const PORT = process.env.PORT || 3000;

// Middleware
app.use(express.json());
app.use(express.static(path.join(__dirname, '../public')));

// API routes
app.get('/api/routes', (req, res) => {
  res.json([
    { id: 1, type: 'bus', from: 'New York', to: 'Boston', price: 25, seats: 12 },
    { id: 2, type: 'train', from: 'New York', to: 'Washington', price: 45, seats: 8 }
  ]);
});

// Handle React routing, return all requests to React app
app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, '../public/index.html'));
});

// Start server
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
  console.log(`React app available at http://localhost:${PORT}/index.html`);
});