import { Line } from 'react-chartjs-2'
import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend
} from 'chart.js'
import './StockChart.css'

ChartJS.register(
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend
)

export default function StockChart({ data }) {
  const chartData = {
    labels: data.labels,
    datasets: [
      {
        label: 'Stock Price',
        data: data.data,
        borderColor: 'navy',
        backgroundColor: 'rgba(0, 0, 128, 0.1)',
        tension: 0.1
      }
    ]
  }

  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: 'top'
      },
      title: {
        display: true,
        text: 'Price History'
      }
    },
    scales: {
      y: {
        beginAtZero: false
      }
    }
  }

  return (
    <div className="stock-chart">
      <Line data={chartData} options={options} />
    </div>
  )
}
