import React from 'react'
import MapGL, { Source, Layer, NavigationControl } from 'react-map-gl'
import styled from 'styled-components'
import { forestGreen } from '../theme'

const MapContainer = styled.div`
  height: 100%;
  border-radius: 8px;
  overflow: hidden;
  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
`

const MapView = ({ selectedAreas, setSelectedAreas }) => {
  const [viewport, setViewport] = React.useState({
    latitude: 37.7749,
    longitude: -122.4194,
    zoom: 11
  })

  return (
    <MapContainer>
      <MapGL
        {...viewport}
        width="100%"
        height="100%"
        mapStyle="mapbox://styles/mapbox/streets-v11"
        onViewportChange={setViewport}
        mapboxApiAccessToken={process.env.REACT_APP_MAPBOX_TOKEN}
      >
        <NavigationControl showCompass={false} />
        {/* Add layers for selected areas */}
        {selectedAreas.map(area => (
          <Source
            key={area.id}
            type="geojson"
            data={area.geojson}
          >
            <Layer
              id={area.id}
              type="fill"
              paint={{
                'fill-color': forestGreen,
                'fill-opacity': 0.5,
                'fill-outline-color': '#000'
              }}
            />
          </Source>
        ))}
      </MapGL>
    </MapContainer>
  )
}

export default MapView
