import { Race } from '../context/GameState'
import './RaceSelection.css'

interface RaceSelectionProps {
  onSelect: () => void
}

const RaceSelection = ({ onSelect }: RaceSelectionProps) => {
  const races: Race[] = ['Human', 'Dragonborn', 'Elf', 'Dwarf']
  const raceDescriptions = {
    Human: "Versatile and adaptable with balanced bonuses",
    Dragonborn: "Strong warriors with combat advantages",
    Elf: "Skilled archers and magic users",
    Dwarf: "Excellent miners and craftsmen"
  }

  return (
    <div className="race-selection">
      <h2>Choose Your Race</h2>
      <div className="race-options">
        {races.map((race) => (
          <div key={race} className="race-option">
            <h3>{race}</h3>
            <p>{raceDescriptions[race]}</p>
            <button onClick={onSelect}>Select {race}</button>
          </div>
        ))}
      </div>
    </div>
  )
}

export default RaceSelection
